class Compilateur
  
  def self.traiter(file_exe)


    version = $dmk_version

    dir_lib = file_exe.dirname

    dir_dmk = dir_lib.join("../../../DreaMaker Tout/")
    dir_compilation = dir_dmk.join("Compilation")
    dir_release = dir_dmk.join("Release")
    dir_documentation = dir_compilation.join("Documentation")


    pack = File.join(dir_release, "DreaMaker-v#{version}")


    if DA::file_exists?(pack)
      if DA::file_directory?(pack)
        FileUtils.remove_dir(pack)
      else
        DA::file_delete(pack)
      end
    end

    # On cre le dossier
    FileUtils.mkdir(pack)

    liste = []
    liste << file_exe
    liste << DA::file_first(dir_documentation.join("Lisez-moi-*"))
    liste << DA::file_first(dir_documentation.join("Manuel-*"))
    liste << DA::file_first(dir_documentation.join("Version-*"))


    # On copie les fichiers
    FileUtils.cp_r(liste, pack)

    puts "Supression des fichiers"
    DA::file_delete(file_exe)

    puts "Renommage des fichiers"

    # Renommage du exe
    avant = File.join(pack, "main.exe")
    apres = File.join(pack, "DreaMaker-v#{version}.exe")
    FileUtils.cp(avant, apres)
    FileUtils.rm(avant)

    # On ouvre le dossier
    system("explorer #{pack.gsub("/", "\\")}")


  end

  

  CARAC_INFO = "\n"

  def self.creer_info(argv)

    # Structure des infos
    #
    # - pro | free
    # - numero client
    # -

    mode, num = *argv

    contenu = ""


    contenu << "$pro = #{mode == "pro"}\n"
    contenu << "$num = \"#{num}\"\n"
    
    DA::file_write(F_COMPILER, contenu)

    DA::file_write(F_COMPIL)

  end



end